//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//datawqܶqbe128r`]0x00~0x7F^a}Ŷ
//idatawqܶqb]0x00~0xFF^a}Ŷ
//xdatawqܶqhObW~XiRAMŶ]@~0xF000~0xF1FFŶAŶjp]ӲAS~RAM^

//datawqܶqt׳̧֡AidataAxdatae̺C
//`QϥΪܼƥdata/idataŧi; `ϥΪܼƥxdataŧi.

#if (Vbus_Protect == 1)
   uint8 MotorErrorState = 0;
	//uint8 MotorErrorState = OverVbus | UnderVbus;
	xdata uint16 OverVbusProtectCount = BUS_VOLT_Debounce;
	xdata uint16 UnderVbusProtectCount = BUS_VOLT_Debounce;
#else
	uint8 MotorErrorState = 0;
#endif

#if (Temperature_Protect == 1)
	xdata uint16 OverTemperatureProtectCount = TEMPERATURE_Debounce;
#endif

#if (FaultLock_Protect == 1)
	xdata uint16	mot_lock_cnt = 0; 
#endif

#if(LACK_OF_PHASE_Protect == 1)
	xdata   uint16  Lack_Phase_Max_Current = dLACK_PHASE_MAX_CURRENT;
#endif

// #if (POCP_Protect == 1)
	xdata uint16 POCP_ProtectCount = PHASE_OCP_DURATION;
	xdata int16 	IaFb;
	xdata int16 	IbFb;
	xdata int16 	IcFb;
// #endif

	xdata int16		IA_ABS;
	xdata int16		IB_ABS;
	xdata int16		IC_ABS;
	xdata int16		IA_ABS_MAX = 0;
	xdata int16		IB_ABS_MAX = 0;
	xdata int16		IC_ABS_MAX = 0;
	

xdata uint16 	MotorStartDelayCount 	= 0;
idata uint8		ProtectState = 0;
//********************************************************************************
//								   Protect Scan
//********************************************************************************
void Protect_scan(void){	//10ms
	switch(ProtectState){

		case 0 : //LO@
			#if (Vbus_Protect == 1)
				Vbus_Protect_Fun(Vbus_avg);
			#endif
			ProtectState = 1;
		break;
		
		case 1 : //O@
			#if (FaultLock_Protect == 1)
				FaultLock_Fun();
			#endif	
			ProtectState = 2;
		break;
		
		case 2 : //LūO@
			#if (Temperature_Protect == 1)
				Temperature_Protect_Fun(Temperature_avg);
			#endif	
			ProtectState = 3;
		break;
		
		case 3 : //ʬ۫O@
			#if (LACK_OF_PHASE_Protect == 1)
				LACK_OF_PHASE_Function();
			#endif	
			ProtectState = 0;
		break;
		
	}
}
//********************************************************************************
//								    OVP/UVP
//********************************************************************************
#if (Vbus_Protect == 1)
void Vbus_Protect_Fun (uint16 Adc_Vbus){	//40ms
	if(Adc_Vbus > OVER_BUS_VOLT_VALUE){
		if(OverVbusProtectCount >= BUS_VOLT_Debounce){
			OverVbusProtectCount = BUS_VOLT_Debounce; 
			MotorErrorState |= OverVbus;
		}
		else
			OverVbusProtectCount += 1;
	}
	else{
		if(Adc_Vbus < CLEAR_OVER_BUS_VOLT_VALUE){
			if(OverVbusProtectCount < 1){
				OverVbusProtectCount = 0;
				MotorErrorState &= ~(OverVbus);
			}
			else
				OverVbusProtectCount -= 1;
		}
	}

	if(Adc_Vbus < UNDER_BUS_VOLT_VALUE){
		if(UnderVbusProtectCount >= BUS_VOLT_Debounce){
			UnderVbusProtectCount = BUS_VOLT_Debounce; 
			MotorErrorState |= UnderVbus;
		}
		else
			UnderVbusProtectCount += 1;
	}
	else{
		if(Adc_Vbus > CLEAR_UNDER_BUS_VOLT_VALUE){
			if(UnderVbusProtectCount < 1){
				UnderVbusProtectCount = 0;
				MotorErrorState &= ~(UnderVbus);
			}
			else
				UnderVbusProtectCount -= 1;
		}
	}
}
#endif
//********************************************************************************
//								     OTP
//********************************************************************************
#if (Temperature_Protect == 1)
void Temperature_Protect_Fun (uint16 Adc_Temperature){ //40ms
	if(Adc_Temperature > OVER_TEMPERATURE_VALUE){
		if(OverTemperatureProtectCount >= TEMPERATURE_Debounce){
			OverTemperatureProtectCount = TEMPERATURE_Debounce; 
			MotorErrorState |= OverTemperature;
		}
		else
			OverTemperatureProtectCount += 1;
	}
	else{
		if(Adc_Temperature < CLEAR_OVER_TEMPERATURE_VALUE){
			if(OverTemperatureProtectCount < 1){
				OverTemperatureProtectCount = 0;
				MotorErrorState &= ~(OverTemperature);
			}
			else
				OverTemperatureProtectCount -= 1;
		}
	}
}
#endif
//********************************************************************************
//								 Lock Protect
//********************************************************************************
#if (FaultLock_Protect == 1)
void FaultLock_Fun (void){   //40ms
	if(FLAG.MOTOR_PWM_ENABLE==1){
		if(PllOutTemp >= SMO_PLL_END_SPD){
			if(EstimatedSpeed > OverSpeed){
				mot_lock_cnt += 1;
			}
			else if(EstimatedSpeed <= UnderSpeed){
				mot_lock_cnt += 1;
			}
			else{
				if(mot_lock_cnt > 0)
					mot_lock_cnt -= 1;		
			}

			if(mot_lock_cnt > FaultLock_Debounce){
				mot_lock_cnt = 0;
				MotorErrorState = FaultLock;
			}
			
		}
		else{
			mot_lock_cnt = 0;
			if(MotorState != M_ERROR){
				MotorFaultState = 0;
			}
		}
	}
}
#endif
//********************************************************************************
//								      OCP
//********************************************************************************
void AOCP_Protect_Fun (void){
	if(MotorState == M_IPD){
		MotorErrorState &= ~(AOCP);
	}
	else{
		MotorErrorState |= AOCP;
	}
}
//********************************************************************************
//								    Ibus OCP
//********************************************************************************
// void IBUS_OCP_Protect_Fun (void){
	
// }
//********************************************************************************
//								   Phase  OCP
//********************************************************************************
// #if (POCP_Protect == 1)
void Phase_OCP_Protect_Fun (void){
	// xdata int16 IcFb;
	
	IaFb = dFB_Ia;
	IbFb = dFB_Ib;
	IcFb = -IaFb - IbFb;
	
	IA_ABS = abs(IaFb);
	IB_ABS = abs(IbFb);
	IC_ABS = abs(IcFb);
	
	if(IA_ABS>IA_ABS_MAX)
		IA_ABS_MAX = IA_ABS;
	if(IB_ABS>IB_ABS_MAX)
		 IB_ABS_MAX = IB_ABS;	 
	if(IC_ABS>IC_ABS_MAX)
		 IC_ABS_MAX = IC_ABS;
	
	
	if((abs(IaFb) > PHASE_OCP_VALUE) || (abs(IbFb) > PHASE_OCP_VALUE) || (abs(IcFb) > PHASE_OCP_VALUE)){
		if(POCP_ProtectCount >= PHASE_OCP_DURATION){
			POCP_ProtectCount = PHASE_OCP_DURATION; 
			MotorErrorState |= POCP;
		}
		else
			POCP_ProtectCount += 10;
	}
	else{
		if(POCP_ProtectCount < 1){
			POCP_ProtectCount = 0;
			MotorErrorState &= ~(POCP);
		}
		else
			POCP_ProtectCount -= 10;
	}
}
// #endif	
//********************************************************************************
//							 MotorStartRetry_Flow
//********************************************************************************
void MotorStartRetry_Flow (void){
	if(													//~P_Ҧƭ
		#if (AOCP_Retry_ENABLE == 1)
			((MotorErrorState & AOCP) == AOCP)||
		#endif
		
		#if (POCP_Retry_ENABLE == 1)
			((MotorErrorState & POCP) == POCP)||
		#endif
		
		#if (OTP_Retry_ENABLE == 1)
			((MotorErrorState & OverTemperature) == OverTemperature)||
		#endif
		
		#if (FaultLock_Retry_ENABLE == 1)
			((MotorErrorState & FaultLock) == FaultLock)||
		#endif
		
		#if (LPP_Retry_ENABLE == 1)
			((MotorErrorState & LPP) == LPP)||
		#endif
		0)
	{
		MotorStartDelayCount++;
		if(MotorStartDelayCount >= RESTART_DURATION){
			MotorStartDelayCount = 0;
			MotorStartRetryCount++;
			if(MotorStartRetryCount >= RETRY_COUNT){
				MotorState = M_ERROR;	//_q 
			}
			else{
				//If using OCP USER Mode.
				// if((MotorErrorState & AOCP) == AOCP)
					// OCPNCONT |= 0x02;// Clear AOCP/DOCP Status
				MotorState = M_OFF; 
				MotorErrorState = Clear;
			}
		}
	}	
	else{ 
		MotorState = M_ERROR;	//_q 
	}
}